/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.themes;

import jaredbgreat.dldungeons.builder.BlockFamily;
import jaredbgreat.dldungeons.builder.RegisteredBlock;
import jaredbgreat.dldungeons.nbt.NBTHelper;
import jaredbgreat.dldungeons.pieces.chests.LootCategory;
import jaredbgreat.dldungeons.pieces.chests.LootHandler;
import jaredbgreat.dldungeons.pieces.chests.LootItem;
import jaredbgreat.dldungeons.pieces.chests.LootListSet;
import jaredbgreat.dldungeons.pieces.chests.TreasureChest;
import jaredbgreat.dldungeons.setup.Externalizer;
import jaredbgreat.dldungeons.themes.Element;
import jaredbgreat.dldungeons.themes.SizeElement;
import jaredbgreat.dldungeons.themes.Theme;
import jaredbgreat.dldungeons.themes.ThemeFlags;
import jaredbgreat.dldungeons.themes.ThemeType;
import jaredbgreat.dldungeons.util.debug.Logging;
import jaredbgreat.dldungeons.util.parser.Tokenizer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ThemeReader {
    private static File configDir;
    private static File themesDir;
    private static File chestDir;
    private static File blocksDir;
    public static final String CHESTS_DIR = "SpecialChests";
    public static final String BLOCKS_DIR = "BlockFamilies";
    private static ArrayList<File> files;
    private static final String ESTRING = "";

    public static void setThemesDir(File dir) {
        Logging.logInfo("themesdir is " + dir);
        themesDir = dir;
    }

    public static void setConfigDir(File dir) {
        Logging.logInfo("themesdir is " + dir);
        configDir = dir;
    }

    public static String getThemesDir() {
        return themesDir + File.separator;
    }

    public static String getConfigDir() {
        return configDir + File.separator;
    }

    private static int findChestFiles(File dir) {
        int num = 0;
        files = new ArrayList();
        String[] fileNames = dir.list();
        if (fileNames.length < 1) {
            return 0;
        }
        for (String name : fileNames) {
            if (name.length() < 5 || !name.substring(name.length() - 4).equalsIgnoreCase(".cfg")) continue;
            files.add(new File(name));
            ++num;
        }
        return num;
    }

    private static int findThemeFiles(File dir) {
        int num = 0;
        files = new ArrayList();
        String[] fileNames = dir.list();
        if (fileNames.length < 1) {
            Externalizer exporter = new Externalizer(dir.toString() + File.separator);
            exporter.makeThemes();
            fileNames = dir.list();
        }
        if (fileNames.length < 1) {
            return 0;
        }
        for (String name : fileNames) {
            if (name.length() <= 4 || name.equals("template.cfg") || !name.substring(name.length() - 4).equalsIgnoreCase(".cfg")) continue;
            files.add(new File(name));
            ++num;
        }
        return num;
    }

    private static int findBlockFiles(File dir) {
        String[] fileNames;
        int num = 0;
        files = new ArrayList();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if ((fileNames = dir.list()).length < 1) {
            Externalizer exporter = new Externalizer(dir.toString() + File.separator);
            exporter.makeBlocks();
            fileNames = dir.list();
        }
        if (fileNames.length < 1) {
            return 0;
        }
        for (String name : fileNames) {
            if (name.length() <= 5 || !name.substring(name.length() - 5).equalsIgnoreCase(".json")) continue;
            files.add(new File(name));
            ++num;
        }
        if (num > 0) {
            ThemeReader.readBlockFamilies(blocksDir);
        }
        return num;
    }

    public static void readThemes() {
        TreasureChest.initSlots();
        ThemeReader.openNBTConfig();
        ThemeReader.openLoot("chests.cfg", true);
        chestDir = new File(configDir.toString() + File.separator + CHESTS_DIR);
        if (!chestDir.exists()) {
            chestDir.mkdir();
        }
        int num = ThemeReader.findChestFiles(chestDir);
        Logging.logInfo("Found " + num + " special chest configs.");
        for (File file : files) {
            ThemeReader.openLoot(file.toString(), false);
        }
        blocksDir = new File(configDir.toString() + File.separator + BLOCKS_DIR);
        num = ThemeReader.findBlockFiles(blocksDir);
        Logging.logInfo("Found " + num + " block family configs.");
        num = ThemeReader.findThemeFiles(themesDir);
        Logging.logInfo("Found " + num + " themes.");
        for (File file : files) {
            ThemeReader.readTheme(file);
        }
    }

    private static void readBlockFamilies(File dir) {
        String[] fileNames;
        if (!(dir.exists() && dir.isDirectory() && dir.canRead())) {
            Logging.logInfo("WARNING: " + dir + " did not exist or was not a valid directory!");
            return;
        }
        BufferedReader instream = null;
        for (String fn : fileNames = dir.list()) {
            if (!fn.substring(fn.length() - 5).equalsIgnoreCase(".json")) continue;
            StringBuilder json = new StringBuilder();
            fn = dir.toString() + File.separator + fn;
            try {
                instream = new BufferedReader(new FileReader(fn));
                while (instream.ready()) {
                    json.append(instream.readLine());
                }
                instream.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            RegisteredBlock.add(BlockFamily.makeBlockFamily(json.toString()));
        }
    }

    public static void openNBTConfig() {
        BufferedReader instream = null;
        File nbtconfig = new File(configDir.toString() + File.separator + "nbt.cfg");
        if (nbtconfig.exists()) {
            try {
                instream = new BufferedReader(new FileReader(nbtconfig.toString()));
                ThemeReader.readNBT(instream);
                if (instream != null) {
                    instream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            Logging.logInfo("File nbt.cfg is missing; will fallabck on default loot");
        }
    }

    public static void readNBT(BufferedReader instream) throws IOException {
        Logging.logInfo("Loading custom NBT tags (nbt.cfg)");
        Object tokens = null;
        String line = null;
        while ((line = instream.readLine()) != null) {
            if (line.length() < 2 || line.charAt(0) == '#') continue;
            NBTHelper.parseNBTLine(line);
        }
    }

    public static void openLoot(String name, boolean isMain) {
        LootCategory cat = LootHandler.getLootHandler().createCategory(name);
        BufferedReader instream = null;
        File chests = isMain ? new File(configDir.toString() + File.separator + name) : new File(configDir.toString() + File.separator + CHESTS_DIR + File.separator + name);
        if (chests.exists()) {
            try {
                instream = new BufferedReader(new FileReader(chests.toString()));
                ThemeReader.readLoot(instream, name, cat.getLists());
                if (instream != null) {
                    instream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            Logging.logInfo("File " + name + " is missing; will fallabck on default loot");
            cat.getLists().addDefaultLoot();
        }
    }

    public static void readLoot(BufferedReader instream, String filename, LootListSet loots) throws IOException {
        Logging.logInfo("Loading chest loot file (" + filename + ")");
        Tokenizer tokens = null;
        String line = null;
        while ((line = instream.readLine()) != null) {
            if (line.length() < 2 || line.charAt(0) == '#' || !(tokens = new Tokenizer(line, " ,;:\t\n\r\f=")).hasMoreTokens()) continue;
            String type = tokens.nextToken().toLowerCase();
            if (!tokens.hasMoreTokens()) continue;
            int level = ThemeReader.intParser(tokens);
            if (!tokens.hasMoreTokens() || level == 0) continue;
            String modid = tokens.nextToken();
            if (modid.toLowerCase().equalsIgnoreCase("item") || modid.toLowerCase().equalsIgnoreCase("block")) {
                modid = "minecraft";
            }
            if (!tokens.hasMoreTokens()) continue;
            String name = tokens.nextToken();
            if (!tokens.hasMoreTokens()) continue;
            int min = ThemeReader.intParser(tokens);
            if (!tokens.hasMoreTokens() || min < 1) continue;
            int max = ThemeReader.intParser(tokens);
            String item = modid + ":" + name;
            LootItem loot = new LootItem(item, min, max, level);
            if (item == null || loot == null) continue;
            while (tokens.hasMoreTokens()) {
                loot.addNbt(tokens.nextToken());
            }
            loot.trimNbt();
            loots.addItem(loot, type, level);
        }
        loots.addDiscs();
    }

    private static void readTheme(File file) {
        BufferedReader instream = null;
        try {
            instream = new BufferedReader(new FileReader(themesDir.toString() + File.separator + file.toString()));
            ThemeReader.parseTheme(instream, file.toString());
            if (instream != null) {
                instream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NoSuchElementException e) {
            File errorFile;
            if (instream != null) {
                try {
                    instream.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            Logging.logError("Theme " + file.toString() + " contained a fatal error!");
            e.printStackTrace();
            File broken = new File(themesDir.toString() + File.separator + file.toString());
            File errorDir = new File(themesDir.toString() + File.separator + "errors");
            if (!errorDir.exists()) {
                errorDir.mkdir();
            }
            int i = 0;
            while ((errorFile = new File(errorDir.toString() + File.separator + file.toString() + ".err" + i++)).exists()) {
            }
            if (!broken.renameTo(errorFile)) {
                try {
                    Files.move(broken.toPath(), errorFile.toPath(), new CopyOption[0]);
                }
                catch (IOException ex) {
                    Logger.getLogger(ThemeReader.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (errorFile.exists()) {
                Logging.logError("Theme " + errorFile + " was renamed to prevent  further reading attempts; please fix it.");
            }
            Logging.logError("Theme " + errorFile + " was NOT renamed to prevent  further reading attempts (please fix it); something went wrong!");
        }
    }

    public static void parseTheme(BufferedReader instream, String name) throws IOException, NoSuchElementException {
        Theme theme = new Theme();
        theme.name = name;
        theme.version = 2;
        Tokenizer tokens = null;
        String line = null;
        String delimeters = " ,;\t\n\r\f=";
        while ((line = instream.readLine()) != null) {
            if (line.length() < 2 || line.charAt(0) == '#' || !(tokens = new Tokenizer(line, delimeters)).hasMoreTokens()) continue;
            String token = tokens.nextToken().toLowerCase();
            if (token.equalsIgnoreCase("miny")) {
                theme.minY = ThemeReader.intParser(theme.minY, tokens);
                continue;
            }
            if (token.equalsIgnoreCase("maxy")) {
                theme.maxY = ThemeReader.intParser(theme.maxY, tokens);
                continue;
            }
            if (token.equalsIgnoreCase("buildfoundation")) {
                theme.buildFoundation = ThemeReader.booleanParser(theme.buildFoundation, tokens);
                continue;
            }
            if (token.equalsIgnoreCase("sizes")) {
                theme.sizes = ThemeReader.sizeParser(theme.sizes, tokens);
                continue;
            }
            if (token.equalsIgnoreCase("dimensionwhitelist")) {
                theme.dimensionWhitelist = ThemeReader.dimensionParser(tokens);
                continue;
            }
            if (token.equalsIgnoreCase("outside")) {
                theme.outside = ThemeReader.elementParser(theme.outside, tokens);
                continue;
            }
            if (token.equalsIgnoreCase("liquids")) {
                theme.liquids = ThemeReader.elementParser(theme.liquids, tokens);
                continue;
            }
            if (token.equalsIgnoreCase("subrooms")) {
                theme.subrooms = ThemeReader.elementParser(theme.subrooms, tokens);
                continue;
            }
            if (token.equalsIgnoreCase("islands")) {
                theme.islands = ThemeReader.elementParser(theme.islands, tokens);
                continue;
            }
            if (token.equalsIgnoreCase("pillars")) {
                theme.pillars = ThemeReader.elementParser(theme.pillars, tokens);
                continue;
            }
            if (token.equalsIgnoreCase("symmetry")) {
                theme.symmetry = ThemeReader.elementParser(theme.symmetry, tokens);
                continue;
            }
            if (token.equalsIgnoreCase("variability")) {
                theme.variability = ThemeReader.elementParser(theme.variability, tokens);
                continue;
            }
            if (token.equalsIgnoreCase("degeneracy")) {
                theme.degeneracy = ThemeReader.elementParser(theme.degeneracy, tokens);
                continue;
            }
            if (token.equalsIgnoreCase("complexity")) {
                theme.complexity = ThemeReader.elementParser(theme.complexity, tokens);
                continue;
            }
            if (token.equalsIgnoreCase("verticle")) {
                theme.verticle = ThemeReader.elementParser(theme.verticle, tokens);
                continue;
            }
            if (token.equalsIgnoreCase("naturals")) {
                theme.naturals = ThemeReader.elementParser(theme.naturals, tokens);
                continue;
            }
            if (token.equalsIgnoreCase("entrances")) {
                theme.entrances = ThemeReader.elementParser(theme.entrances, tokens);
                continue;
            }
            if (token.equalsIgnoreCase("air")) {
                theme.air = ThemeReader.blockParser(theme.air, tokens, theme.version);
                continue;
            }
            if (token.equalsIgnoreCase("walls")) {
                theme.walls = ThemeReader.blockParser(theme.walls, tokens, theme.version);
                continue;
            }
            if (token.equalsIgnoreCase("caveblock")) {
                theme.caveWalls = ThemeReader.blockParser(theme.caveWalls, tokens, theme.version);
                continue;
            }
            if (token.equalsIgnoreCase("floors")) {
                theme.floors = ThemeReader.blockParser(theme.floors, tokens, theme.version);
                continue;
            }
            if (token.equalsIgnoreCase("ceilings")) {
                theme.ceilings = ThemeReader.blockParser(theme.ceilings, tokens, theme.version);
                continue;
            }
            if (token.equalsIgnoreCase("fencing")) {
                theme.fencing = ThemeReader.blockParser(theme.fencing, tokens, theme.version);
                continue;
            }
            if (token.equalsIgnoreCase("liquid")) {
                theme.liquid = ThemeReader.blockParser(theme.liquid, tokens, theme.version);
                continue;
            }
            if (token.equalsIgnoreCase("pillarblock")) {
                theme.pillarBlock = ThemeReader.blockParser(theme.pillarBlock, tokens, theme.version);
                continue;
            }
            if (token.equalsIgnoreCase("commonmobs")) {
                theme.commonMobs = ThemeReader.parseMobs(theme.commonMobs, tokens);
                continue;
            }
            if (token.equalsIgnoreCase("hardmobs")) {
                theme.hardMobs = ThemeReader.parseMobs(theme.hardMobs, tokens);
                continue;
            }
            if (token.equalsIgnoreCase("brutemobs")) {
                theme.bruteMobs = ThemeReader.parseMobs(theme.bruteMobs, tokens);
                continue;
            }
            if (token.equalsIgnoreCase("elitemobs")) {
                theme.eliteMobs = ThemeReader.parseMobs(theme.eliteMobs, tokens);
                continue;
            }
            if (token.equalsIgnoreCase("bossmobs")) {
                theme.bossMobs = ThemeReader.parseMobs(theme.bossMobs, tokens);
                continue;
            }
            if (token.equalsIgnoreCase("biomes")) {
                theme.biomes = ThemeReader.biomeParser(tokens);
                continue;
            }
            if (token.equalsIgnoreCase("notinbiomes")) {
                theme.notIn = ThemeReader.biomeParser(tokens);
                continue;
            }
            if (token.equalsIgnoreCase("biomewhitelist")) {
                theme.biomewl.addAll(ThemeReader.specificBiomeParser(tokens));
                continue;
            }
            if (token.equalsIgnoreCase("biomeblacklist")) {
                theme.biomebl.addAll(ThemeReader.specificBiomeParser(tokens));
                continue;
            }
            if (token.equalsIgnoreCase("chestsfile")) {
                theme.lootCat = tokens.nextToken();
                continue;
            }
            if (token.equalsIgnoreCase("type")) {
                theme.type = ThemeReader.typeParser(tokens);
                for (ThemeType type : theme.type) {
                    ThemeType.addThemeToType(theme, type);
                }
                if (theme.type.contains((Object)ThemeType.WATER)) {
                    theme.air = new int[]{RegisteredBlock.add("minecraft:water")};
                }
                if (!theme.type.contains((Object)ThemeType.SWAMP)) continue;
                theme.flags.add(ThemeFlags.SWAMPY);
                continue;
            }
            if (token.equalsIgnoreCase("flags")) {
                theme.flags = ThemeReader.flagParser(tokens);
                continue;
            }
            if (!token.equalsIgnoreCase("version")) continue;
            theme.version = (int)ThemeReader.floatParser(theme.version, tokens);
        }
        if (theme.air.length < 1) {
            theme.air = new int[]{RegisteredBlock.add("minecraft:air")};
        }
        theme.fixMobs();
        theme.biomeRegister();
        if (theme.caveWalls.length < 1) {
            theme.caveWalls = theme.walls;
        }
    }

    private static Element elementParser(Element el, Tokenizer tokens) {
        boolean valid = false;
        int[] values = new int[]{0, 0, 0, 0, 0, 0};
        for (int i = 0; i < values.length && tokens.hasMoreTokens(); ++i) {
            String num = tokens.nextToken();
            values[i] = Integer.parseInt(num);
            if (values[i] < 0) {
                values[i] = 0;
            }
            if (values[i] <= 0) continue;
            valid = true;
        }
        if (valid) {
            return new Element(values[0], values[1], values[2], values[3], values[4], values[5]);
        }
        return el;
    }

    private static SizeElement sizeParser(SizeElement el, Tokenizer tokens) {
        boolean valid = false;
        int[] values = new int[]{0, 0, 0, 0, 0};
        for (int i = 0; i < values.length && tokens.hasMoreTokens(); ++i) {
            String num = tokens.nextToken();
            values[i] = Integer.parseInt(num);
            if (values[i] < 0) {
                values[i] = 0;
            }
            if (values[i] <= 0) continue;
            valid = true;
        }
        if (valid) {
            return new SizeElement(values[0], values[1], values[2], values[3], values[4]);
        }
        return el;
    }

    private static int[] dimensionParser(Tokenizer tokens) {
        if (tokens.getToken(1) == null || tokens.getToken(1).equalsIgnoreCase("all")) {
            return new int[0];
        }
        int[] rtn = new int[tokens.countTokens() - 1];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            rtn[i++] = Integer.parseInt(tokens.nextToken());
        }
        return rtn;
    }

    private static int intParser(int el, Tokenizer tokens) {
        boolean valid = false;
        int value = 0;
        String num = ESTRING;
        try {
            if (tokens.hasMoreTokens() && (value = Integer.parseInt(num = tokens.nextToken())) > 5 && value < 224) {
                valid = true;
            }
        }
        catch (Exception e) {
            Logging.logError("ThemeReader.intParser(int el, Tokenizer tokens) tried to read non-number as integer");
            Logging.logError("Value passed as and integer was: " + num);
            e.printStackTrace();
            return el;
        }
        if (valid) {
            return value;
        }
        return el;
    }

    private static float floatParser(float el, Tokenizer tokens) {
        float value = 0.0f;
        String num = ESTRING;
        try {
            if (tokens.hasMoreTokens()) {
                num = tokens.nextToken();
                value = Float.parseFloat(num);
            }
        }
        catch (Exception e) {
            Logging.logError("ThemeReader.floatParser(float el, Tokenizer tokens) tried to read non-number as float");
            Logging.logError("Value passed as and foat was: " + num);
            return el;
        }
        return value;
    }

    private static int intParser(Tokenizer tokens) {
        int value = 0;
        String num = ESTRING;
        try {
            if (tokens.hasMoreTokens()) {
                num = tokens.nextToken().trim();
                value = Integer.parseInt(num);
            }
        }
        catch (Exception e) {
            Logging.logError("ThemeReader.intParser(Tokenizer tokens) tried to read non-number as integer");
            Logging.logError("Value passed as and integer was: " + num);
            return -1;
        }
        return value;
    }

    private static boolean booleanParser(boolean el, Tokenizer tokens) {
        boolean valid = false;
        if (!tokens.hasMoreTokens()) {
            return el;
        }
        boolean bool = Boolean.parseBoolean(tokens.nextToken());
        return bool;
    }

    private static int[] blockParser(int[] el, Tokenizer tokens, float version) throws NoSuchElementException {
        int i;
        ArrayList<String> values = new ArrayList<String>();
        while (tokens.hasMoreTokens()) {
            String nums = tokens.nextToken();
            values.add(String.valueOf(RegisteredBlock.add(nums)));
        }
        int[] out = new int[values.size() + el.length];
        for (i = 0; i < el.length; ++i) {
            out[i] = el[i];
        }
        for (i = 0; i < values.size(); ++i) {
            out[i + el.length] = Integer.parseInt((String)values.get(i));
        }
        return out;
    }

    private static ArrayList<String> parseMobs(ArrayList<String> el, Tokenizer tokens) {
        ArrayList<String> mobs = el != null ? el : new ArrayList();
        while (tokens.hasMoreTokens()) {
            String nextMob = tokens.nextToken();
            mobs.add(nextMob);
        }
        return mobs;
    }

    private static HashSet<BiomeDictionary.Type> biomeParser(Tokenizer tokens) {
        HashSet<BiomeDictionary.Type> biomes = new HashSet<BiomeDictionary.Type>();
        while (tokens.hasMoreTokens()) {
            String name = tokens.nextToken().toUpperCase();
            if (name.equalsIgnoreCase("ALL")) {
                biomes.add(BiomeDictionary.Type.FOREST);
                biomes.add(BiomeDictionary.Type.PLAINS);
                biomes.add(BiomeDictionary.Type.MOUNTAIN);
                biomes.add(BiomeDictionary.Type.HILLS);
                biomes.add(BiomeDictionary.Type.SWAMP);
                biomes.add(BiomeDictionary.Type.WATER);
                biomes.add(BiomeDictionary.Type.JUNGLE);
                biomes.add(BiomeDictionary.Type.WASTELAND);
                biomes.add(BiomeDictionary.Type.BEACH);
                biomes.add(BiomeDictionary.Type.NETHER);
                biomes.add(BiomeDictionary.Type.END);
                biomes.add(BiomeDictionary.Type.MUSHROOM);
                biomes.add(BiomeDictionary.Type.MAGICAL);
                biomes.add(BiomeDictionary.Type.HOT);
                biomes.add(BiomeDictionary.Type.COLD);
                biomes.add(BiomeDictionary.Type.DENSE);
                biomes.add(BiomeDictionary.Type.SPARSE);
                biomes.add(BiomeDictionary.Type.WET);
                biomes.add(BiomeDictionary.Type.DRY);
                biomes.add(BiomeDictionary.Type.SAVANNA);
                biomes.add(BiomeDictionary.Type.CONIFEROUS);
                biomes.add(BiomeDictionary.Type.SPOOKY);
                biomes.add(BiomeDictionary.Type.DEAD);
                biomes.add(BiomeDictionary.Type.LUSH);
                biomes.add(BiomeDictionary.Type.MESA);
                biomes.add(BiomeDictionary.Type.SANDY);
                biomes.add(BiomeDictionary.Type.SNOWY);
                continue;
            }
            if (name.equalsIgnoreCase("FOREST")) {
                biomes.add(BiomeDictionary.Type.FOREST);
                continue;
            }
            if (name.equalsIgnoreCase("PLAINS")) {
                biomes.add(BiomeDictionary.Type.PLAINS);
                continue;
            }
            if (name.equalsIgnoreCase("MOUNTAINS")) {
                biomes.add(BiomeDictionary.Type.MOUNTAIN);
                continue;
            }
            if (name.equalsIgnoreCase("HILLS")) {
                biomes.add(BiomeDictionary.Type.HILLS);
                continue;
            }
            if (name.equalsIgnoreCase("SWAMP")) {
                biomes.add(BiomeDictionary.Type.SWAMP);
                continue;
            }
            if (name.equalsIgnoreCase("WATER")) {
                biomes.add(BiomeDictionary.Type.WATER);
                continue;
            }
            if (name.equalsIgnoreCase("JUNGLE")) {
                biomes.add(BiomeDictionary.Type.JUNGLE);
                continue;
            }
            if (name.equalsIgnoreCase("WASTELAND")) {
                biomes.add(BiomeDictionary.Type.WASTELAND);
                continue;
            }
            if (name.equalsIgnoreCase("BEACH")) {
                biomes.add(BiomeDictionary.Type.BEACH);
                continue;
            }
            if (name.equalsIgnoreCase("NETHER")) {
                biomes.add(BiomeDictionary.Type.NETHER);
                continue;
            }
            if (name.equalsIgnoreCase("END")) {
                biomes.add(BiomeDictionary.Type.END);
                continue;
            }
            if (name.equalsIgnoreCase("MUSHROOM")) {
                biomes.add(BiomeDictionary.Type.MUSHROOM);
                continue;
            }
            if (name.equalsIgnoreCase("MAGICAL")) {
                biomes.add(BiomeDictionary.Type.MAGICAL);
                continue;
            }
            if (name.equalsIgnoreCase("HOT")) {
                biomes.add(BiomeDictionary.Type.HOT);
                continue;
            }
            if (name.equalsIgnoreCase("COLD")) {
                biomes.add(BiomeDictionary.Type.COLD);
                continue;
            }
            if (name.equalsIgnoreCase("DENSE")) {
                biomes.add(BiomeDictionary.Type.DENSE);
                continue;
            }
            if (name.equalsIgnoreCase("SPARSE")) {
                biomes.add(BiomeDictionary.Type.SPARSE);
                continue;
            }
            if (name.equalsIgnoreCase("WET")) {
                biomes.add(BiomeDictionary.Type.WET);
                continue;
            }
            if (name.equalsIgnoreCase("DRY")) {
                biomes.add(BiomeDictionary.Type.DRY);
                continue;
            }
            if (name.equalsIgnoreCase("SAVANNA")) {
                biomes.add(BiomeDictionary.Type.SAVANNA);
                continue;
            }
            if (name.equalsIgnoreCase("CONIFEROUS")) {
                biomes.add(BiomeDictionary.Type.CONIFEROUS);
                continue;
            }
            if (name.equalsIgnoreCase("SPOOKY")) {
                biomes.add(BiomeDictionary.Type.SPOOKY);
                continue;
            }
            if (name.equalsIgnoreCase("DEAD")) {
                biomes.add(BiomeDictionary.Type.DEAD);
                continue;
            }
            if (name.equalsIgnoreCase("LUSH")) {
                biomes.add(BiomeDictionary.Type.LUSH);
                continue;
            }
            if (name.equalsIgnoreCase("MESA")) {
                biomes.add(BiomeDictionary.Type.MESA);
                continue;
            }
            if (name.equalsIgnoreCase("SANDY")) {
                biomes.add(BiomeDictionary.Type.SANDY);
                continue;
            }
            if (!name.equalsIgnoreCase("SNOWY")) continue;
            biomes.add(BiomeDictionary.Type.SNOWY);
        }
        return biomes;
    }

    private static EnumSet<ThemeType> typeParser(Tokenizer tokens) {
        EnumSet<ThemeType> types = EnumSet.noneOf(ThemeType.class);
        while (tokens.hasMoreTokens()) {
            String name = tokens.nextToken().toUpperCase();
            if (name.equalsIgnoreCase("FOREST")) {
                types.add(ThemeType.FOREST);
                continue;
            }
            if (name.equalsIgnoreCase("PLAINS")) {
                types.add(ThemeType.PLAINS);
                continue;
            }
            if (name.equalsIgnoreCase("MOUNTAINS")) {
                types.add(ThemeType.MOUNTAIN);
                continue;
            }
            if (name.equalsIgnoreCase("SWAMP")) {
                types.add(ThemeType.SWAMP);
                continue;
            }
            if (name.equalsIgnoreCase("WATER")) {
                types.add(ThemeType.WATER);
                continue;
            }
            if (name.equalsIgnoreCase("DESERT")) {
                types.add(ThemeType.DESERT);
                continue;
            }
            if (name.equalsIgnoreCase("FROZEN")) {
                types.add(ThemeType.FROZEN);
                continue;
            }
            if (name.equalsIgnoreCase("JUNGLE")) {
                types.add(ThemeType.JUNGLE);
                continue;
            }
            if (name.equalsIgnoreCase("WASTELAND")) {
                types.add(ThemeType.WASTELAND);
                continue;
            }
            if (name.equalsIgnoreCase("NETHER")) {
                types.add(ThemeType.NETHER);
                continue;
            }
            if (name.equalsIgnoreCase("END")) {
                types.add(ThemeType.END);
                continue;
            }
            if (name.equalsIgnoreCase("MUSHROOM")) {
                types.add(ThemeType.MUSHROOM);
                continue;
            }
            if (name.equalsIgnoreCase("MAGICAL")) {
                types.add(ThemeType.MAGICAL);
                continue;
            }
            if (name.equalsIgnoreCase("DUNGEON")) {
                types.add(ThemeType.DUNGEON);
                continue;
            }
            if (name.equalsIgnoreCase("URBAN")) {
                types.add(ThemeType.URBAN);
                continue;
            }
            if (name.equalsIgnoreCase("NECRO")) {
                types.add(ThemeType.NECRO);
                continue;
            }
            if (name.equalsIgnoreCase("FIERY")) {
                types.add(ThemeType.FIERY);
                continue;
            }
            if (name.equalsIgnoreCase("SHADOW")) {
                types.add(ThemeType.SHADOW);
                continue;
            }
            if (name.equalsIgnoreCase("TECH")) {
                types.add(ThemeType.TECH);
                continue;
            }
            if (!name.equalsIgnoreCase("PARADISE")) continue;
            types.add(ThemeType.PARADISE);
        }
        return types;
    }

    private static Set<Biome> specificBiomeParser(Tokenizer tokens) {
        HashSet<Biome> biomes = new HashSet<Biome>();
        while (tokens.hasMoreTokens()) {
            biomes.add((Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(tokens.nextToken())));
        }
        return biomes;
    }

    private static EnumSet<ThemeFlags> flagParser(Tokenizer tokens) {
        EnumSet<ThemeFlags> flags = EnumSet.noneOf(ThemeFlags.class);
        while (tokens.hasMoreTokens()) {
            String name = tokens.nextToken().toUpperCase();
            if (name.equalsIgnoreCase("SWAMPY")) {
                flags.add(ThemeFlags.SWAMPY);
                continue;
            }
            if (name.equalsIgnoreCase("WATER")) {
                flags.add(ThemeFlags.WATER);
                continue;
            }
            if (!name.equalsIgnoreCase("SURFACE")) continue;
            flags.add(ThemeFlags.SURFACE);
        }
        return flags;
    }
}

